<?php

namespace Teamnet\FaxApi\Soap\Client;

use Exception;
use Teamnet\FaxApi\Soap\Types\FaxRecipient;

/**
 * Represents a list of recipients, expected
 * by Teamnet_Fax_Soap_Client_SendFax::sendFaxToRecipientList
 * @author tingelhoff@teamnet.de
 * @copyright Teamnet GmbH
 * @version 1.0
 */
class RecipientList {
	private $aList;
	
	
	/**
	 * @throws Exception
	 */
	public function __construct($recipientList = array() ) {
		$list = array();
		foreach( $recipientList as $recipient ) {
			if ( $recipient instanceof FaxRecipient ) {
				$list[] = $recipient;
			}
			else if ( is_array( $recipient ) ) {
				$faxRecipient = new FaxRecipient();
				if ( array_key_exists( 0, $recipient ) ) {
					$faxRecipient->faxnumber = $recipient[0];
				}
				else if ( array_key_exists( 'faxnumber', $recipient ) ) {
					$faxRecipient->faxnumber = $recipient['faxnumber'];
				}
				if ( array_key_exists( 1, $recipient ) ) {
					$faxRecipient->name = $recipient[1];
				}
				else if ( array_key_exists( 'name', $recipient ) ) {
					$faxRecipient->name = $recipient['name'];
				}
				if ( array_key_exists( 2, $recipient ) ) {
					$faxRecipient->customerReference = $recipient[2];
				}
				else if ( array_key_exists( 'customerReference', $recipient ) ) {
					$faxRecipient->customerReference = $recipient['customerReference'];
				}
				$list[] = $faxRecipient;
			}
			else if ( is_string( $recipient ) ) {
				$faxRecipient = new FaxRecipient();
				$faxRecipient->faxnumber = $recipient;
				$list[] = $faxRecipient;
			}
			else {
				throw new Exception( sprintf( "Unsupported type [%s] to construct a RecipientList.", get_class( $recipientList ) ) );
			}
		}
		$this->aList = $list;
	}
	
	
	
	/**
	 * Adds an recipient to this list
	 * @param string		$sFaxNumber
	 * @param string|null	$sName
	 * @param string|null	$sCustomerReference
	 * @return RecipientList fluent interface
	 */
	public function addRecipient( $sFaxNumber, $sName = null, $sCustomerReference = null ) {
		$oRecipient = new FaxRecipient();
		$oRecipient->faxnumber = $sFaxNumber;
		$oRecipient->name = $sName;
		$oRecipient->customerReference = $sCustomerReference;
		$this->add( $oRecipient );
		
		return $this;
	}
	
	
	
	public function add( $oRecipient ) {
		$this->aList[] = $oRecipient;
		return $this;
	}
	
	
	
	
	/**
	 * @return array FaxRecipient objects
	 */
	public function getRecipients() {
		return $this->aList;
	}

}