<?php
/*********************************************
 job09.php : Job aus Zeitfenster suchen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Suche durchfuehren
 4) Ergebnis anzeigen
*********************************************/
require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Clients einbinden
*********************************************/

// SOAP-Client zum Abfragen von Faxjobdaten einbinden
use Teamnet\FaxApi\Soap\Client\Job;

// SOAP-Client zur Definition von Zeitfenstern ( = Perioden) einbinden
use Teamnet\FaxApi\Soap\Types\Period;


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/job.php?wsdl';

// Autorisierungs-Schluessel
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Suchparameter:  Titel (leer)
$jobtitle = NULL;

// Suchparameter:  Status (nur abgeschlossene Faxjobs suchen)
$status = 'finished';

// Zeitfenster instanzieren
$period = new Period();

// Startzeitpunkt
$period->from = '2022-09-27T00:00:00+01:00';

// Endzeitpunkt
$period->until = '2022-09-28T00:00:00+01:00';


/*********************************************
3) Suche durchfuehren  
*********************************************/

// FaxJob instanzieren
$faxJob = new Job( $WSDL , $authkey );

// Suchanfrage abschicken
$result = $faxJob->getList($jobtitle, $status , $period);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

// Moegliche Rueckgabewerte:
// - Array von APIJob Objekten
// - NULL wenn keine APIJobs gefunden wurden

if (is_array($result)) 
{
	echo '<pre>'.htmlspecialchars(print_r($result , true)).'</pre>';
} else {
	echo 'Keine Jobs gefunden';
}
