<?php
/*********************************************
 sendfax03.php : HTML als Fax an mehrere Empfaenger senden
 1) SOAP-Clients einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/

require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Clients einbinden
*********************************************/

// SOAP-Client zum Versenden von Faxen einbinden
use Teamnet\FaxApi\Soap\Client\SendFax;

// SOAP-Client zum Versenden an mehrere Empfaenger einbinden
use Teamnet\FaxApi\Soap\Client\RecipientList;


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummern
$faxnumbers = array('XXXXXXXXXXXXXX');

// Bezeichnung des Faxjobs
$jobtitle = 'Fax-API HTML Testfax Empfaengerliste';

// Als Faxvorlagetyp wird HTML uebergeben
$contenttype = 'text/html';

// HTML Datei laden
$content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$sendFax = new SendFax( $WSDL, $authkey );

// Empfaengerliste erzeugen
$recipientList = new RecipientList( $faxnumbers );

// Faxauftrag abschicken
$jobID = $sendFax->sendFaxToRecipientList( $jobtitle, $contenttype, $content, $recipientList );


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$jobID.' eingeplant';
