<?php
/*********************************************
 sendfax02.php : PDF als Fax an einen Empfaenger senden 
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/

require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\SendFax;


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer
$faxnumber = 'XXXXXXXXXXXXXX';

// Bezeichnung des Faxjobs
$jobtitle = 'Fax-API PDF Testfax';

// Als Faxvorlagetyp wird ein PDF uebergeben
$contenttype = 'application/pdf';

// PDF Datei laden
$content = file_get_contents ('resources/example.pdf');


/*********************************************
3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$sendFax = new SendFax( $WSDL, $authkey );

// Faxauftrag abschicken
$jobID = $sendFax->sendFaxToFaxnumber	(	$jobtitle
												, $contenttype
												, $content
												, $faxnumber
											);

/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$jobID.' eingeplant';

