<?php
/*
 * The script retrieves the current state of the service
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/System/operation/getHealth
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "health";

/*
 * STEP A:
 * Define URL
 */
$url = $restUrl.$restResource;

/* 
 * STEP B:
 * Create and set curl
 */
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_HTTPHEADER, [
	'Content-Type: application/json'
] );

/* 
 * STEP C:
 * Execute call 
 */
$result = curl_exec($curl);
if(!$result){die("Connection Failure");}
curl_close($curl);

/* 
 * STEP D: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;