<?php
/*
 * This script changes the state of an existing job
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Job-Details/operation/putJob
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "jobs/";

/*
 * STEP A:
 * Set needed script variables
 */
$token	= 'xxx'; //type here your api token
$jobID	= 'xxx'; //type here the id of the job you want to query

/* 
 * STEP B:
 * Set the  requestBody and encode it
 */
$requestBody = [
	"action" => null //"hold" "cancel" "resume"
];
$json = json_encode($requestBody);


/*
 * STEP C:
 * Define URL
 */
$url = $restUrl.$restResource.$jobID;

/* 
 * STEP D:
 * Create and set curl
 */
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($curl, CURLOPT_HTTPHEADER, [
	'Content-Type: application/json',
	'X-Auth-Token: '.$token
] );
curl_setopt($curl, CURLOPT_POSTFIELDS, $json);

/* 
 * STEP E:
 * Execute call 
 */
$result = curl_exec($curl);
if(!$result){die("Connection Failure");}
curl_close($curl);

/* 
 * STEP F: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;