<?php
/*
 * The script retrieves a list of existing jobs without using further filters.
 * Please use the script "getJobListDetail.php" if you want to use filter.
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Jobs/operation/getJobs
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "jobs";

/*
 * STEP A:
 * Set needed script variables
 */
$token	= 'xxx'; //type here your api token

/*
 * STEP B:
 * Define URL
 */
$url = $restUrl.$restResource;

/* 
 * STEP C:
 * Create and set curl
 */
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_HTTPHEADER, [
	'Content-Type: application/json',
	'X-Auth-Token: '.$token
] );

/* 
 * STEP D:
 * Execute call 
 */
$result = curl_exec($curl);
if(!$result){die("Connection Failure");}
curl_close($curl);

/* 
 * STEP E: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;