<?php
/*********************************************
 job07.php : Job suchen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Suche durchfuehren
 4) Ergebnis anzeigen
*********************************************/


/*********************************************
1) SOAP-Client zum Abfragen von Faxjobdaten einbinden
*********************************************/

require_once 'Teamnet/Fax/Soap/Client/Job.php';


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/job.php?wsdl';

// Autorisierungs-Schluessel
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Suchparameter:  Titel (leer)
$s_Jobtitle = NULL;

// Suchparameter:  Status (nur abgeschlossene Faxjobs suchen)
$s_Status = 'finished';


/*********************************************
3) Suche durchfuehren  
*********************************************/

// FaxJob instanzieren
$o_FaxJob = new Teamnet_Fax_Soap_Client_Job( $s_WSDL , $s_Authkey );

// Suchanfrage abschicken
$m_Result = $o_FaxJob->getList($s_Jobtitle , $s_Status);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

// Moegliche Rueckgabewerte:
// - Array von APIJob Objekten
// - NULL wenn keine APIJobs gefunden wurden
if (is_array($m_Result)) 
{
	echo '<pre>'.htmlspecialchars(print_r($m_Result , true)).'</pre>';
} else {
	echo 'Keine Jobs gefunden';
}