<?php
/*********************************************
 sendfax04.php : HTML als Fax an vordefinierte Verteilerlisten senden 
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/


/*********************************************
1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/
require_once 'Teamnet/Fax/Soap/Client/SendFax.php';


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Bezeichnung des Faxjobs
$s_Jobtitle = 'Fax-API HTML Testfax Verteilerliste';

// Als Faxvorlagetyp wird HTML uebergeben
$s_Contenttype = 'text/html';

// HTML Datei laden
$s_Content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';

// ID der Verteilerliste aus der Faxsuite
$i_DistributionListId = 1;


/*********************************************
3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$o_SendFax = new Teamnet_Fax_Soap_Client_SendFax( $s_WSDL, $s_Authkey );

// Faxauftrag abschicken
$i_JobID = $o_SendFax->sendFaxToDistributionList( $s_Jobtitle, $s_Contenttype, $s_Content, $i_DistributionListId);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$i_JobID.' eingeplant';