<?php
/*********************************************
 sendfax03.php : HTML als Fax an mehrere Empfaenger senden
 1) SOAP-Clients einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/


/*********************************************
1) SOAP-Clients einbinden
*********************************************/

// SOAP-Client zum Versenden von Faxen einbinden
require_once 'Teamnet/Fax/Soap/Client/SendFax.php';

// SOAP-Client zum Versenden an mehrere Empfaenger einbinden
require_once 'Teamnet/Fax/Soap/Client/RecipientList.php';


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummern
$a_Faxnumbers = array('00495251682540014989', '00495251682540014989', '00495251682540014989');

// Bezeichnung des Faxjobs
$s_Jobtitle = 'Fax-API HTML Testfax Empfaengerliste';

// Als Faxvorlagetyp wird HTML uebergeben
$s_Contenttype = 'text/html';

// HTML Datei laden
$s_Content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$o_SendFax = new Teamnet_Fax_Soap_Client_SendFax( $s_WSDL, $s_Authkey );

// Empfaengerliste erzeugen
$o_RecipientList = new Teamnet_Fax_Soap_Client_RecipientList( $a_Faxnumbers );

// Faxauftrag abschicken
$i_JobID = $o_SendFax->sendFaxToRecipientList( $s_Jobtitle, $s_Contenttype, $s_Content, $o_RecipientList );


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$i_JobID.' eingeplant';
