<?php
/*********************************************
 sendfax05.php : Variation von Faxversandoptionen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/


/*********************************************
1) SOAP-Clients einbinden
*********************************************/

// SOAP-Client zum Versenden von Faxen einbinden
require_once 'Teamnet/Fax/Soap/Client/SendFax.php';

// SOAP-Client fuer Versandoptionen einbinden
require_once 'Teamnet/Fax/Soap/Type/JobOptions.php';


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/sendfax.php?wsdl';

// Autorisierungs-Schluessel
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer mit Landesvorwahl
$s_Faxnumber = '00495251682540014989';

// Bezeichnung des Faxjobs
$s_Jobtitle = 'Fax-API HTML JobOptions';

// Als Faxvorlagetyp wird HTML uebergeben
$s_Contenttype = 'text/html';

// HTML Datei laden
$s_Content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
3) Fax einplanen
*********************************************/

// JobOptionen instanzieren
$o_JobOptions = new Teamnet_Fax_Soap_Type_JobOptions();
// Kostenstelle
$o_JobOptions->costcenter = 'Kostenstelle';
// Kopfzeile im Faxdokument anzeigen
$o_JobOptions->faxheader = true;
// Absender-Kennung in der Kopfzeile
$o_JobOptions->faxheaderFrom = 'sendfax05.php';
// Station-ID
$o_JobOptions->stationid = 'Teamnet';
// Versandzeitpunkt
$o_JobOptions->timetosend = '2012-03-03T09:10:00+01:00';

// Sendfax instanzieren
$o_SendFax = new Teamnet_Fax_Soap_Client_SendFax( $s_WSDL, $s_Authkey );

// Faxauftrag abschicken
$i_JobID = $o_SendFax->sendFaxToFaxnumber	(	$s_Jobtitle
												, $s_Contenttype
												, $s_Content
												, $s_Faxnumber
												, $o_JobOptions
											);

											
/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$i_JobID.' eingeplant';
